<?php
declare(strict_types=1);

require_once __DIR__ . '/../utils.php';
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../auth.php';

$admin = require_role('admin');

$body = get_request_json();
$ownerId = (int)($body['owner_id'] ?? 0);
$name = safe_string($body['name'] ?? '', 180);
$whatsapp = safe_string($body['whatsapp_phone'] ?? '', 30);
$description = safe_string($body['description'] ?? '', 2000);
$address = safe_string($body['address'] ?? '', 255);

if ($ownerId <= 0 || $name === '' || $whatsapp === '') {
  json_response(['ok' => false, 'error' => 'VALIDATION', 'message' => 'owner_id, name, whatsapp_phone are required'], 422);
}

// ensure owner exists and is owner role
$own = db()->prepare("SELECT id FROM users WHERE id = ? AND role='owner' AND is_active=1 LIMIT 1");
$own->execute([$ownerId]);
if (!$own->fetch()) {
  json_response(['ok' => false, 'error' => 'NOT_FOUND', 'message' => 'Owner not found'], 404);
}

try {
  $stmt = db()->prepare("
    INSERT INTO shops (owner_id, name, description, whatsapp_phone, address, is_verified, is_suspended, created_at)
    VALUES (?, ?, ?, ?, ?, 0, 0, ?)
  ");
  $stmt->execute([$ownerId, $name, $description ?: null, $whatsapp, $address ?: null, now_utc()]);
  $shopId = (int)db()->lastInsertId();

  json_response([
    'ok' => true,
    'shop' => [
      'id' => $shopId,
      'owner_id' => $ownerId,
      'name' => $name,
      'whatsapp_phone' => $whatsapp,
      'is_verified' => 0,
      'is_suspended' => 0
    ]
  ]);
} catch (Throwable $e) {
  json_response(['ok' => false, 'error' => 'CREATE_FAILED', 'message' => APP_DEBUG ? $e->getMessage() : 'Failed'], 500);
}
