<?php
declare(strict_types=1);

require_once __DIR__ . '/../utils.php';
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../auth.php';

$admin = require_role('admin');

$status = $_GET['status'] ?? 'open';
$status = in_array($status, ['open','resolved'], true) ? $status : 'open';

$stmt = db()->prepare("
  SELECT id, target_type, target_id, reason, message, reporter_phone, status, created_at, resolved_at
  FROM reports
  WHERE status = ?
  ORDER BY id DESC
  LIMIT 200
");
$stmt->execute([$status]);

json_response([
  'ok' => true,
  'reports' => $stmt->fetchAll()
]);
