<?php
declare(strict_types=1);

require_once __DIR__ . '/../utils.php';
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../auth.php';

$body = get_request_json();
$emailOrPhone = safe_string($body['login'] ?? '', 150);
$password = (string)($body['password'] ?? '');

if ($emailOrPhone === '' || $password === '') {
  json_response(['ok' => false, 'error' => 'VALIDATION', 'message' => 'login and password are required'], 422);
}

$stmt = db()->prepare("
  SELECT id, role, full_name, phone, email, password_hash, must_change_password, is_active
  FROM users
  WHERE (email = ? OR phone = ?)
  LIMIT 1
");
$stmt->execute([$emailOrPhone, $emailOrPhone]);
$user = $stmt->fetch();

if (!$user || (int)$user['is_active'] !== 1) {
  json_response(['ok' => false, 'error' => 'INVALID_CREDENTIALS'], 401);
}

if (!password_verify($password, (string)$user['password_hash'])) {
  json_response(['ok' => false, 'error' => 'INVALID_CREDENTIALS'], 401);
}

$tokenInfo = create_auth_token((int)$user['id'], 60 * 60 * 24 * 7); // 7 days

json_response([
  'ok' => true,
  'token' => $tokenInfo['token'],
  'expires_at' => $tokenInfo['expires_at'],
  'user' => [
    'id' => (int)$user['id'],
    'role' => $user['role'],
    'full_name' => $user['full_name'],
    'phone' => $user['phone'],
    'email' => $user['email'],
    'must_change_password' => (int)$user['must_change_password'],
  ]
]);
