<?php
declare(strict_types=1);

/**
 * Basic API config + headers.
 * Keep declare(strict_types=1) as the FIRST statement.
 */

// Debug
define('APP_DEBUG', true);

if (APP_DEBUG) {
  ini_set('display_errors', '1');
  error_reporting(E_ALL);
} else {
  ini_set('display_errors', '0');
  error_reporting(E_ALL & ~E_NOTICE & ~E_DEPRECATED & ~E_STRICT);
}

// CORS + JSON
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, PATCH, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Access-Control-Allow-Credentials: true');

if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') {
  http_response_code(204);
  exit;
}

// DB settings
define('DB_HOST', 'localhost');
define('DB_NAME', 'daura_shop');
define('DB_USER', 'daura_user');
define('DB_PASS', 'Daura@12345');
