<?php
declare(strict_types=1);

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/utils.php';

function db(): PDO {
  static $pdo = null;
  if ($pdo instanceof PDO) return $pdo;

  $dsn = 'mysql:host=' . DB_HOST . ';dbname=' . DB_NAME . ';charset=utf8mb4';

  try {
    $pdo = new PDO($dsn, DB_USER, DB_PASS, [
      PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
      PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
      PDO::ATTR_EMULATE_PREPARES => false,
    ]);
  } catch (Throwable $e) {
    json_response([
      'ok' => false,
      'error' => 'DB_CONNECTION_FAILED',
      'message' => APP_DEBUG ? $e->getMessage() : 'Database connection failed'
    ], 500);
  }

  return $pdo;
}

function db_healthcheck(): bool {
  try {
    $stmt = db()->query('SELECT 1');
    $row = $stmt->fetch();
    return (bool)$row;
  } catch (Throwable $e) {
    return false;
  }
}
