<?php
declare(strict_types=1);

require_once __DIR__ . '/../utils.php';
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../auth.php';

$u = require_role('owner');
require_password_changed_for_owner($u);

$shopStmt = db()->prepare("SELECT id FROM shops WHERE owner_id = ? LIMIT 1");
$shopStmt->execute([(int)$u['id']]);
$shop = $shopStmt->fetch();
if (!$shop) json_response(['ok' => false, 'error' => 'NOT_FOUND', 'message' => 'Shop not found'], 404);
$shopId = (int)$shop['id'];

$productId = (int)($_POST['product_id'] ?? 0);
if ($productId <= 0) json_response(['ok' => false, 'error' => 'VALIDATION', 'message' => 'product_id required'], 422);

$name = safe_string($_POST['name'] ?? '', 180);
$description = safe_string($_POST['description'] ?? '', 2000);
$priceRaw = $_POST['price'] ?? '';
$price = $priceRaw !== '' ? (float)$priceRaw : null;
$isActiveRaw = $_POST['is_active'] ?? null;

$imageUrl = save_uploaded_image(
  'image',
  __DIR__ . '/../../uploads/products',
  '/shop-system/uploads/products'
);

$existing = db()->prepare("SELECT id FROM products WHERE id = ? AND shop_id = ? LIMIT 1");
$existing->execute([$productId, $shopId]);
if (!$existing->fetch()) json_response(['ok' => false, 'error' => 'NOT_FOUND', 'message' => 'Product not found'], 404);

$sql = "UPDATE products SET updated_at = ? ";
$params = [now_utc()];

if ($name !== '') { $sql .= ", name = ?"; $params[] = $name; }
if ($description !== '') { $sql .= ", description = ?"; $params[] = $description; }
if ($price !== null && $price > 0) { $sql .= ", price = ?"; $params[] = $price; }
if ($imageUrl) { $sql .= ", image_path = ?"; $params[] = $imageUrl; }
if ($isActiveRaw !== null) { $sql .= ", is_active = ?"; $params[] = ((int)$isActiveRaw ? 1 : 0); }

$sql .= " WHERE id = ? AND shop_id = ?";
$params[] = $productId;
$params[] = $shopId;

$stmt = db()->prepare($sql);
$stmt->execute($params);

json_response(['ok' => true]);
