<?php
declare(strict_types=1);

require_once __DIR__ . '/../utils.php';
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../auth.php';

$u = require_owner();

$body = get_request_json();
$fullName = safe_string($body['full_name'] ?? '', 150);
$phone = safe_string($body['phone'] ?? '', 30);
$email = safe_string($body['email'] ?? '', 150);

if ($fullName === '' || $phone === '' || $email === '') {
  json_response(['ok' => false, 'error' => 'VALIDATION', 'message' => 'full_name, phone, email are required'], 422);
}

// prevent duplicates (excluding self)
$chk = db()->prepare("SELECT id FROM users WHERE (email = ? OR phone = ?) AND id <> ? LIMIT 1");
$chk->execute([$email, $phone, (int)$u['id']]);
if ($chk->fetch()) {
  json_response(['ok' => false, 'error' => 'DUPLICATE', 'message' => 'Email or phone already in use'], 409);
}

$upd = db()->prepare("
  UPDATE users
  SET full_name = ?, phone = ?, email = ?, updated_at = ?
  WHERE id = ? AND role = 'owner'
");
$upd->execute([$fullName, $phone, $email, now_utc(), (int)$u['id']]);

json_response([
  'ok' => true,
  'user' => [
    'id' => (int)$u['id'],
    'role' => $u['role'],
    'full_name' => $fullName,
    'phone' => $phone,
    'email' => $email,
    'must_change_password' => (int)($u['must_change_password'] ?? 0),
  ]
]);
