<?php
declare(strict_types=1);

require_once __DIR__ . '/../utils.php';
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../auth.php';

$u = require_owner();


$body = get_request_json();
$name = safe_string($body['name'] ?? '', 180);
$description = safe_string($body['description'] ?? '', 2000);
$whatsapp = safe_string($body['whatsapp_phone'] ?? '', 30);
$address = safe_string($body['address'] ?? '', 255);

$stmt = db()->prepare("SELECT id FROM shops WHERE owner_id = ? LIMIT 1");
$stmt->execute([(int)$u['id']]);
$row = $stmt->fetch();
if (!$row) json_response(['ok' => false, 'error' => 'NOT_FOUND', 'message' => 'Shop not found'], 404);

$shopId = (int)$row['id'];

$upd = db()->prepare("
  UPDATE shops
  SET name = COALESCE(NULLIF(?, ''), name),
      description = COALESCE(NULLIF(?, ''), description),
      whatsapp_phone = COALESCE(NULLIF(?, ''), whatsapp_phone),
      address = COALESCE(NULLIF(?, ''), address),
      updated_at = ?
  WHERE id = ? AND owner_id = ?
");
$upd->execute([$name, $description, $whatsapp, $address, now_utc(), $shopId, (int)$u['id']]);

json_response(['ok' => true]);
