<?php
declare(strict_types=1);

require_once __DIR__ . '/../utils.php';
require_once __DIR__ . '/../db.php';

$shopId = (int)($_GET['shop_id'] ?? 0);
if ($shopId <= 0) {
  json_response(['ok' => false, 'error' => 'VALIDATION', 'message' => 'shop_id is required'], 422);
}

$shopStmt = db()->prepare("
  SELECT id, owner_id, name, description, whatsapp_phone, logo_path, address,
         is_verified, is_suspended, created_at, updated_at
  FROM shops
  WHERE id = ? AND is_verified = 1 AND is_suspended = 0
  LIMIT 1
");
$shopStmt->execute([$shopId]);
$shop = $shopStmt->fetch();
if (!$shop) json_response(['ok' => false, 'error' => 'NOT_FOUND', 'message' => 'Shop not found'], 404);

$prodStmt = db()->prepare("
  SELECT id, shop_id, name, description, price, image_path, is_active, created_at, updated_at
  FROM products
  WHERE shop_id = ? AND is_active = 1
  ORDER BY id DESC
");
$prodStmt->execute([$shopId]);

json_response(['ok' => true, 'shop' => $shop, 'products' => $prodStmt->fetchAll()]);
