export async function apiGet(url, options = {}) {
  const res = await fetch(url, {
    credentials: "include",
    ...options
  });

  const text = await res.text();
  try {
    return JSON.parse(text);
  } catch {
    return { ok: false, error: "BAD_JSON", raw: text };
  }
}

export async function apiPost(url, data) {
  return apiGet(url, {
    method: "POST",
    headers: { "Content-Type": "application/json" },
    body: JSON.stringify(data)
  });
}
