export function cleanPhone(phone) {
  return String(phone || "").replace(/[^\d]/g, "");
}

export function waLink(phone, message) {
  const p = cleanPhone(phone);
  const txt = encodeURIComponent(message);
  return `https://wa.me/${p}?text=${txt}`;
}

export function buildWhatsAppMessage({ shopName, orderCode, items, total, referralPhone, baseUrl }) {
  const lines = [];
  lines.push(`Hello ${shopName}! I want to order:`);
  lines.push("");

  items.forEach((it, idx) => {
    const link = baseUrl ? `${baseUrl}/shop-system/app/product.html?product_id=${it.product_id}` : "";
    const lineTotal = Number(it.price) * Number(it.qty);
    lines.push(`${idx + 1}) ${it.name} x${it.qty} @ ${it.price} = ${lineTotal}`);
    if (link) lines.push(`   Link: ${link}`);
  });

  lines.push("");
  lines.push(`Estimated Total: ${total}`);
  lines.push(`Order Code: ${orderCode}`);
  if (referralPhone) lines.push(`Referral: ${referralPhone}`);

  return lines.join("\n");
}
